Attribute VB_Name = "Fnet"
Option Explicit

Public Tx() As Byte

Public Sub InitHeader()

    ReDim Tx(19) As Byte

    Tx(0) = CByte(Asc("L"))
    Tx(1) = CByte(Asc("G"))
    Tx(2) = CByte(Asc("I"))
    Tx(3) = CByte(Asc("S"))
    Tx(4) = CByte(Asc("-"))
    Tx(5) = CByte(Asc("G"))
    Tx(6) = CByte(Asc("L"))
    Tx(7) = CByte(Asc("O"))
    Tx(8) = CByte(Asc("F"))
    Tx(9) = CByte(Asc("A"))
    
    Tx(13) = &H33
    
End Sub

Public Function GetDataSize(strVar As String) As Integer

    Dim iLen As Integer
    
    iLen = Len(strVar)

    GetDataSize = iLen / 2

End Function

Public Sub SendData()

    Dim iLen As Integer, i As Integer, strTmp As String
        
    GetReqHeadData Tx
    
    iLen = GetDataSize(formMain.txtReqData)

    ReDim Preserve Tx(20 + 8 + iLen - 1)
    
    Tx(16) = CByte(8 + iLen)            'Length (2)
    Tx(19) = ByteCheckSum(Tx, 0, 18)
   
    Tx(20) = CByte("&H" + Mid(formMain.txtReqCmnd, 1, 2))
    Tx(21) = CByte("&H" + Mid(formMain.txtReqCmnd, 3, 2))
    Tx(22) = CByte("&H" + Mid(formMain.txtReqDataType, 1, 2))
    Tx(23) = CByte("&H" + Mid(formMain.txtReqDataType, 3, 2))
    Tx(24) = 0
    Tx(25) = 0
    Tx(26) = CByte("&H" + Mid(formMain.txtReqVarNo, 1, 2))
    Tx(27) = CByte("&H" + Mid(formMain.txtReqVarNo, 3, 2))
   
    For i = 0 To iLen - 1
        Tx(28 + i) = CByte("&H" + Mid(formMain.txtReqData, i * 2 + 1, 2))
    Next
    
    formMain.tcpClient.SendData Tx
    
End Sub

Public Function ByteCheckSum(Buff() As Byte, iStart As Integer, iEnd As Integer) As Byte
    
    Dim i As Integer
    Dim CheckSum As Integer
    
    For i = iStart To iEnd
        CheckSum = CheckSum + Buff(i)
        If CheckSum > 255 Then CheckSum = CheckSum - 256
    Next
    
    ByteCheckSum = CByte(CheckSum)
    
End Function

Public Sub DisplayReqHeader(aData() As Byte)

    Dim strId As String, i As Integer

    For i = 0 To 9
        strId = strId + Chr(aData(i))
    Next
    
    formMain.txtReqComId = strId
    
    formMain.txtReqSrc = ByteToHexStr(aData(13))
    formMain.txtReqInvokeId = ByteToHexStr(aData(14)) + ByteToHexStr(aData(15))
    formMain.txtReqLength = ByteToHexStr(aData(16)) + ByteToHexStr(aData(17))
    formMain.txtReqCheckSum = ByteToHexStr(aData(19))

End Sub

Public Sub DisplayResHeader(aData() As Byte)

    Dim strId As String, i As Integer

    For i = 0 To 9
        strId = strId + Chr(aData(i))
    Next
    
    formMain.txtResComId = strId
    
    formMain.txtResSrc = ByteToHexStr(aData(13))
    formMain.txtResInvokeId = ByteToHexStr(aData(14)) + ByteToHexStr(aData(15))
    formMain.txtResLength = ByteToHexStr(aData(16)) + ByteToHexStr(aData(17))
    formMain.txtResCheckSum = ByteToHexStr(aData(19))

End Sub

Public Sub DisplayRes(aData() As Byte, lLen As Long)

    Dim strVal As String, i As Long
    
    DisplayResHeader aData

    formMain.txtResCmnd = ByteToHexStr(aData(20)) + ByteToHexStr(aData(21))
    formMain.txtResDataType = ByteToHexStr(aData(22)) + ByteToHexStr(aData(23))
    formMain.txtResState = ByteToHexStr(aData(26)) + ByteToHexStr(aData(27))
    formMain.txtResCode = ByteToHexStr(aData(28)) + ByteToHexStr(aData(29))
 
    If lLen > 30 Then
        For i = 30 To lLen - 1
            strVal = strVal + ByteToHexStr(aData(i))
        Next
        formMain.txtResData = strVal
    Else
        formMain.txtResData = ""
    End If

End Sub

Public Sub ClearRes()

    formMain.txtResComId = ""
    formMain.txtResSrc = ""
    formMain.txtResInvokeId = ""
    formMain.txtResLength = ""
    formMain.txtResCheckSum = ""
    formMain.txtResCmnd = ""
    formMain.txtResDataType = ""
    formMain.txtResState = ""
    formMain.txtResCode = ""
    formMain.txtResData = ""

End Sub

Public Function ByteToHexStr(byData As Byte) As String
    Dim strHex As String
    
    strHex = Hex(byData)
    
    If Len(strHex) < 2 Then _
        strHex = "0" + strHex
    
    ByteToHexStr = strHex

End Function

Public Sub GetReqHeadData(aData() As Byte)
    Dim i As Integer, iLen As String
    
    iLen = Len(formMain.txtReqComId)
    
    For i = 1 To iLen
        Tx(i - 1) = CByte(Asc(Mid(formMain.txtReqComId, i, 1)))
    Next
    
    If iLen < 10 Then
        For i = iLen To 9
            Tx(i) = 0
        Next
    End If
    
    Tx(13) = CByte("&H" + formMain.txtReqSrc)
    
    If Len(formMain.txtReqInvokeId) = 4 Then
        Tx(14) = CByte("&H" + Mid(formMain.txtReqInvokeId, 1, 2))
        Tx(15) = CByte("&H" + Mid(formMain.txtReqInvokeId, 3, 2))
    End If
    
    'formMain.txtResLength
    'formMain.txtResCheckSum

End Sub


